/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.entity;

import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import energon.srpextra.util.Utilities;
import energon.srpextra.util.preset.EParasiteSpawnType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public interface IESpawnRule {
    default public EParasiteSpawnType getSpawnType() {
        return EParasiteSpawnType.LAND;
    }

    default public boolean canSpawn_MobCap(World world) {
        if (this.isWaterMob()) {
            return Utilities.checkCountAquaParasites(world, 0);
        }
        return Utilities.checkCountParasites(world, 15);
    }

    default public boolean isWaterMob() {
        return this.getSpawnType() == EParasiteSpawnType.WATER;
    }

    default public byte groundBase(World world, BlockPos pos, byte phase) {
        if (!world.func_175623_d(pos) && world.func_180495_p(pos).func_185913_b() && world.func_180495_p(pos).func_185904_a().func_76220_a()) {
            return 1;
        }
        return 0;
    }

    public byte spaceBase(World var1, BlockPos var2, byte var3);

    default public byte canSpawnHere(World world, BlockPos pos, byte phase) {
        switch (this.groundBase(world, pos.func_177977_b(), phase)) {
            case 1: {
                switch (this.spaceBase(world, pos, phase)) {
                    case 1: {
                        return this.checkLight(world, pos, phase) ? (byte)1 : 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
                return 0;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    default public boolean checkLight(World world, BlockPos pos, byte phase) {
        if (SRPConfigSystems.evolutionSpawningIgnoreSunlight <= phase) {
            return world.func_175642_b(EnumSkyBlock.BLOCK, pos) < 8;
        }
        return world.func_175642_b(EnumSkyBlock.BLOCK, pos) < 8 && (this.checkNightTime(world) || world.func_175642_b(EnumSkyBlock.SKY, pos) < 13);
    }

    default public boolean checkNightTime(World world) {
        long time = world.func_82737_E() % 24000L;
        return time >= 13000L && time <= 23000L;
    }
}

